# What is it?
A fast and unbreakable encrytion system.
This library has 3 functions, `makeid`, `encrypt`, and `decrypt`.
`makeid` will generate a long, almost collision proof code.

These tools can be very useful in login systems.


# How to use it

## Encyrpt and Decrypt
```py
from PCSS import encrypt, decrypt

# Encode it so that we have a bytes object to pass to encrypt
text = "Hello World!"
key = "key"

# Encode it so that we have a bytes object to pass to encrypt

encoded_text = text.encode()
encoded_key = key.encode()


# Encrypt the text
encrypted_bitarray = encrypt(encoded_text, encoded_key)
print(encrypted_bitarray)
# bitarray('00110110101010000111000011100000110100000110001010100110010000101000000000100000101000000010100010001100010011000010010001101100101011001010110011001100100111000010010010000110010011000110101010101100001001000100001011100010110011100111011000101110011000100101111001101010000111000001011010011110111000100001111001011110011011100110110011101010001101100010110001010110001100101111011010011100111100101010111010011100000100100101001001100010010010100111001001011110100111001001011011101100010010100110111001010010110011000100001010000110000100100101101000101100111101101100110000011100110000100100110011110010001011101110110011001100000110101000110001110110111000101111010011110110101011100100101010101100110101101101011000101010110010101011001001110100010001101000101010101100011011001011011001101110100100101010101011001110101011000011011011101100100001101111011001011110010010101010110011101110')

# Decrypt the bitarray
decrypted_bitarray = decrypt(encrypted_bitarray, encoded_key)

# Change it back into bytes
decrypted_bytes = decrypted_bitarray.tobytes()

# Remove the trailing 0s and convert to string
decrypted_text = decrypted_bytes.rstrip(b'\x00').decode()

print(decrypted_text, text == decrypted_text) 
# Hello World! True
```


## Generate id
```py
from PCSS import makeid

print(makeid()) 
# 3fbe99d84c1b9255565c79d758bebba6e011ba2ca0795c5c50d22519adaf99050e74cb261933091fc4c52d6a7581c3681557e4adf495b1cd1314579e962791efc6d5ceb9133de75cd25a20a99d50cf4b7bf927f61dfa298d69d573da101f26a973241224-a5eb-49fa-828b-f86b89d9a4745480679b-4d20-5b8a-a72b-268877dc086a
# ids will vary.

# These ids are garunteed to be unque, the chance of collision is under 1 / (2^256)


```

